package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.databinding.ObservableBoolean
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.WalletRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import com.example.example.WithDrawalModel
import kotlinx.coroutines.launch
import org.json.JSONObject

class WithdrawMoneyViewModel(
    private val context: Context,
    private val walletRepository: WalletRepository
) :ViewModel(){
    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences= Functions.getSharedPreference(context)
    }

    var noDataViewVisibility = ObservableBoolean(false)
    var recylerViewVisiblity = ObservableBoolean(false)
    var loadMoreLoaderVisibility = ObservableBoolean(false)


    fun showDataView(){
        loadMoreLoaderVisibility.set(false)
        noDataViewVisibility.set(false)
        recylerViewVisiblity.set(true)

    }
    fun hideDataView(){
        loadMoreLoaderVisibility.set(false)
        noDataViewVisibility.set(true)
        recylerViewVisiblity.set(false)
    }


    val _withdrawMoneyLiveData: MutableLiveData<ApiResponce<ArrayList<UserModel>>> = MutableLiveData()
    val withdrawMoneyLiveData: LiveData<ApiResponce<ArrayList<UserModel>>> get() = _withdrawMoneyLiveData

    fun withdrawMoney(totalEarning : Double){
        viewModelScope.launch {
            val params = JSONObject()
            try {
                params.put("coin", "")
                params.put("amount", "" + totalEarning)
                params.put("email", sharedPreferences.getString(Variables.U_PAYOUT_ID, ""))
            } catch (e: Exception) {
                e.printStackTrace()
            }
            walletRepository.withdrawRequest(params,_withdrawMoneyLiveData)
        }
    }



    val _withdrawHistoryLiveData: MutableLiveData<ApiResponce<ArrayList<WithDrawalModel>>> = MutableLiveData()
    val withdrawHistoryLiveData: LiveData<ApiResponce<ArrayList<WithDrawalModel>>> get() = _withdrawHistoryLiveData
    fun withdrawHistory(page : Int){
        viewModelScope.launch {
            val params = JSONObject()
            try {
                params.put("starting_point", "" + page)
            } catch (e: Exception) {
                e.printStackTrace()
            }
            walletRepository.showWithdrawalHistory(params,_withdrawHistoryLiveData)
        }
    }


}
class WithdrawMoneyFactory(
    private val context: Context,
    private val walletRepository: WalletRepository
) : ViewModelProvider.Factory{
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(WithdrawMoneyViewModel::class.java)) {
            return WithdrawMoneyViewModel(context, walletRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}